#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion


namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_WorkloadEvent : BaseTest 
	{
		private BOL.WorkloadEvent _workloadEvent = null;
        private DataTable _dtWorkloadEvent = null;
		

        [SetUp]
        protected void SetUp() 
        {
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtWorkloadEvent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadEvent WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A'", false);
				if (this._dtWorkloadEvent.Rows.Count == 0)
				{
					//Create the Workload
					DataTable workloadProcess = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadProcess WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", false);
					if (workloadProcess.Rows.Count == 0)
					{
						Guid randomProcessGuid =  DataCreator.GetRandomRecordGuid(TABLES.VbecsProcess.TableName, "");
						DataRow drProcess = UnitTestUtil.RunSQLGetDataRow("SELECT * FROM VbecsProcess WHERE VbecsProcessGuid = '" + randomProcessGuid.ToString() + "'");

						BOL.VbecsProcess tmpObj = new BOL.VbecsProcess(drProcess);

						DataRow drNewWorkload = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM WorkloadCache WHERE Code_Id > " + new Random().Next(1,199).ToString());

						tmpObj.AddItem(tmpObj.GetNewWorkLoad(drNewWorkload[TABLES.WorkloadCache.Lmip].ToString()));
						tmpObj.SaveChanges(Common.UpdateFunction.UnitTests);

						workloadProcess = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadProcess WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);
					}

					Common.WorkloadProcessID tmpWorkloadId = (Common.WorkloadProcessID)System.Convert.ToInt16(workloadProcess.Rows[0][TABLES.WorkloadProcess.VbecsProcessId]);

					//Create the WorkloadEvent
					BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(false);
					Guid[] guids = {tmpUnit.BloodUnitGuid};

					DataTable dtWorkloadEvent = BOL.WorkloadEvent.GenerateWorkloadData(tmpWorkloadId, guids, Common.WorkloadTransactionType.Miscellanious, false);
					dtWorkloadEvent = Common.Utility.AppendLastUpdateInformation(dtWorkloadEvent, Common.UpdateFunction.UnitTests);
					new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertWorkloadEvents.StoredProcName, dtWorkloadEvent);

					this._dtWorkloadEvent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadEvent WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A'", false);
				}

				this.RefreshData = false;
			}

			_workloadEvent = new BOL.WorkloadEvent(this._dtWorkloadEvent.Rows[0]);			
        }

		[Test]
		public void Ctor_Guid_Int_Pass()
		{
			System.Guid tstGuid = System.Guid.NewGuid();

			BOL.WorkloadEvent tstWE = new BOL.WorkloadEvent(tstGuid, 1);
			
			Assert.AreEqual(tstWE.WorkloadEventGuid, System.Guid.Empty, "WorkloadEventGuid");
			Assert.AreEqual(tstWE.WorkloadProcessGuid, tstGuid, "WorkloadProcessGuid");
			Assert.AreEqual(tstWE.Multiplier, 1, "Multiplier");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Int_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.WorkloadEvent tstWE = new BOL.WorkloadEvent(this._dtWorkloadEvent.Rows[0]);

			Assert.IsNotNull(tstWE, "WorkloadEvent Object");
			Assert.AreEqual(tstWE.WorkloadEventGuid, this._workloadEvent.WorkloadEventGuid, "WorkloadEventGuid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void GetWorkloadEventsByProcessID_Pass()
		{
			System.Collections.ArrayList al = BOL.WorkloadEvent.GetWorkloadEventsByProcessID(1);
			Assert.IsNotNull(al);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetWorkloadEventsByProcessID_Fail()
		{
		}

		[Test]
		public void GenerateWorkloadData_6Params_Pass()
		{
			System.Guid [] guids = new System.Guid[2];
			guids[0] = new System.Guid();
			guids[1] = new System.Guid();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogin);
			DataTable dt = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitLogin, System.Guid.NewGuid(), System.Guid.NewGuid(), guids, Common.WorkloadTransactionType.Unit, false);
			Assert.IsNotNull(dt, "GenerateWorkloadData_6Params_Pass");
		}

		[Test]
		public void GenerateWorkloadData_5Params_Pass()
		{
			System.Guid [] guids = new System.Guid[2];
			guids[0] = new System.Guid();
			guids[1] = new System.Guid();

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogin);
			DataTable dt = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UnitLogin, guids, System.Guid.NewGuid(), Common.WorkloadTransactionType.Unit, false);
			Assert.IsNotNull(dt, "GenerateWorkloadData_6Params_Pass");
		}
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateWorkloadData_5Params_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateWorkloadData_6Params_Fail()
		{
		}

		
		[Test]
		public void GenerateWorkloadData_7Params_Pass()
		{
			//LogonUserDUZ must have a value for this to pass
			DataTable dtUser = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM VbecsUser");
			Common.LogonUser.LogonUserDUZ = dtUser.Rows[0][TABLES.VbecsUser.UserDUZ].ToString();

			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadProcess WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			Common.WorkloadProcessID wpId = (Common.WorkloadProcessID)dtData.Rows[0][TABLES.WorkloadProcess.VbecsProcessId];

			Common.WorkloadTransactionType wtt = Common.WorkloadTransactionType.Unit;
			System.Guid guid1 = System.Guid.NewGuid();
			System.Guid guid2 = System.Guid.NewGuid();
			System.Guid[] guids = {guid1, guid2};

			System.Collections.ArrayList alCodes = BOL.WorkloadEvent.GetWorkloadEventsByProcessID((int)wpId); 
			int rowCount = 2 * (alCodes.Count == 0 ? 1 : alCodes.Count);

			//System.Guid otGuid = DataCreator.GetRecordGuid("SELECT TOP 1 OrderedTestGuid FROM OrderedTest");
			System.Guid otGuid = System.Guid.NewGuid();
			System.Guid ocGuid = System.Guid.NewGuid();

			DataTable dtTest = BOL.WorkloadEvent.GenerateWorkloadData(wpId, 1, otGuid, ocGuid, guids, wtt, true);
			
			Assert.AreEqual(rowCount, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");

			System.Guid wpGuid = (System.Guid)dtData.Rows[0][TABLES.WorkloadProcess.WorkloadProcessGuid];
			System.Guid tstGuid = (System.Guid)dtTest.Rows[0][TABLES.WorkloadProcess.WorkloadProcessGuid];

			Assert.AreEqual(wpGuid, tstGuid, TABLES.WorkloadProcess.WorkloadProcessGuid);
		}

		[Test]
		public void GenerateWorkloadData_7Params_Fail()
		{
			Common.WorkloadProcessID wpId = Common.WorkloadProcessID.Unknown;
			Common.WorkloadTransactionType wtt = Common.WorkloadTransactionType.Miscellanious;
			System.Guid guid1 = System.Guid.NewGuid();
			System.Guid guid2 = System.Guid.NewGuid();
			System.Guid[] guids = {guid1, guid2};

			System.Guid otGuid = System.Guid.Empty;
			System.Guid ocGuid = System.Guid.Empty;

			DataTable dtTest = BOL.WorkloadEvent.GenerateWorkloadData(wpId, 1, otGuid, ocGuid, guids, wtt, true);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GenerateWorkloadData_4Params_Pass()
		{
			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadProcess WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			Common.WorkloadProcessID wpId = (Common.WorkloadProcessID)dtData.Rows[0][TABLES.WorkloadProcess.VbecsProcessId];

			System.Collections.ArrayList alCodes = BOL.WorkloadEvent.GetWorkloadEventsByProcessID((int)wpId); 
			int rowCount = 2 * (alCodes.Count == 0 ? 1 : alCodes.Count);

			Common.WorkloadTransactionType wtt = Common.WorkloadTransactionType.Unit;
			System.Guid guid1 = System.Guid.NewGuid();
			System.Guid guid2 = System.Guid.NewGuid();
			System.Guid[] guids = {guid1, guid2};

			DataTable dtTest = BOL.WorkloadEvent.GenerateWorkloadData(wpId, guids, wtt, true);

			Assert.AreEqual(rowCount, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");

			System.Guid wpGuid = (System.Guid)dtData.Rows[0][TABLES.WorkloadProcess.WorkloadProcessGuid];
			System.Guid tstGuid = (System.Guid)dtTest.Rows[0][TABLES.WorkloadProcess.WorkloadProcessGuid];

			Assert.AreEqual(wpGuid, tstGuid, TABLES.WorkloadProcess.WorkloadProcessGuid);
		}

		[Test]
		public void GenerateWorkloadData_4Params_Fail()
		{
			Common.WorkloadProcessID wpId = Common.WorkloadProcessID.Unknown;
			Common.WorkloadTransactionType wtt = Common.WorkloadTransactionType.Miscellanious;
			System.Guid guid1 = System.Guid.NewGuid();
			System.Guid guid2 = System.Guid.NewGuid();
			System.Guid[] guids = {guid1, guid2};

			DataTable dtTest = BOL.WorkloadEvent.GenerateWorkloadData(wpId, guids, wtt, true);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetWorkloadEventDT_Pass()
		{
			System.Collections.ArrayList al=new System.Collections.ArrayList();

			for(int i=0; i<10 ; i++)
			{
				BOL.WorkloadEvent we = new BOL.WorkloadEvent(System.Guid.NewGuid(), i);
				al.Add(we);
			}
			DataTable dtWes=BOL.WorkloadEvent.GetWorkloadEventDT(al);

			Assert.IsNotNull(dtWes);
			Assert.IsTrue(dtWes.Rows.Count>0);
		}

		[Test]
		[ExpectedException( typeof(System.InvalidCastException) )]
		public void GetWorkloadEventDT_Fail()
		{
			System.Collections.ArrayList al=new System.Collections.ArrayList();

			for(int i=0; i<10 ; i++)
			{
				BOL.VbecsUser we = new BOL.VbecsUser();
				al.Add(we);
			}
			DataTable dtWes=BOL.WorkloadEvent.GetWorkloadEventDT(al);

			Assert.IsNotNull(dtWes);
			Assert.IsTrue(dtWes.Rows.Count>0);
		}

		[Test]
		public void GetEmptyWorkloadEventDataTable_Pass()
		{
			DataTable dtWes=BOL.WorkloadEvent.GetEmptyWorkloadEventDataTable();

			Assert.IsNotNull(dtWes);
			Assert.IsTrue(dtWes.Columns.Count>0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyWorkloadEventDataTable_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr = this._workloadEvent.LoadDataRowFromThis( this._dtWorkloadEvent.Rows[0] );
			//
			Assert.IsTrue( dr != null  );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		#region Properties

        [Test]
		public void WorkloadEventGuid_Pass()
		{
			System.Guid tmpGuid = System.Guid.NewGuid();

			this._workloadEvent.WorkloadEventGuid = tmpGuid;
			Assert.AreEqual(this._workloadEvent.WorkloadEventGuid, tmpGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void WorkloadEventGuid_Fail()
		{
		}

		[Test]
		public void WorkloadProcessGuid_Pass()
		{
			System.Guid tmpGuid = System.Guid.NewGuid();

			this._workloadEvent.WorkloadProcessGuid = tmpGuid;
			Assert.AreEqual(this._workloadEvent.WorkloadProcessGuid, tmpGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void WorkloadProcessGuid_Fail()
		{
		}

		[Test]
		public void BloodUnitGuid_Pass()
		{
			System.Guid tmpGuid = System.Guid.NewGuid();

			this._workloadEvent.BloodUnitGuid = tmpGuid;
			Assert.AreEqual(this._workloadEvent.BloodUnitGuid, tmpGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitGuid_Fail()
		{
		}

		[Test]
		public void PatientGuid_Pass()
		{
			System.Guid tmpGuid = System.Guid.NewGuid();

			this._workloadEvent.PatientGuid = tmpGuid;
			Assert.AreEqual(this._workloadEvent.PatientGuid, tmpGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientGuid_Fail()
		{
		}

		[Test]
		public void Multiplier_Pass()
		{
			this._workloadEvent.Multiplier = 50;
			Assert.AreEqual(this._workloadEvent.Multiplier, 50);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Multiplier_Fail()
		{
		}

		[Test]
		public void WorkloadEvent_OrderedComponentGuid_Pass()
		{
			System.Guid tmpGuid = System.Guid.NewGuid();

			this._workloadEvent.OrderedComponentGuid = tmpGuid;
			Assert.AreEqual(this._workloadEvent.OrderedComponentGuid, tmpGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void WorkloadEvent_OrderedComponentGuid_Fail()
		{
		}

		[Test]
		public void OrderedTestGuid_Pass()
		{
			System.Guid tmpGuid = System.Guid.NewGuid();

			this._workloadEvent.WorkloadProcessGuid = tmpGuid;
			Assert.AreEqual(this._workloadEvent.WorkloadProcessGuid, tmpGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderedTestGuid_Fail()
		{
		}

		[Test]
		public void MiscellanousGuid_Pass()
		{
			System.Guid tmpGuid = System.Guid.NewGuid();

			this._workloadEvent.MiscellanousGuid = tmpGuid;
			Assert.AreEqual(this._workloadEvent.MiscellanousGuid, tmpGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void MiscellanousGuid_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			this._workloadEvent.RecordStatusCode = Common.RecordStatusCode.Active;
			Assert.AreEqual(this._workloadEvent.RecordStatusCode, Common.RecordStatusCode.Active);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void WorkloadEventStatusCode_Pass()
		{
			this._workloadEvent.WorkloadEventStatusCode = Common.WorkloadEventStatus.InProcess;
			Assert.AreEqual(this._workloadEvent.WorkloadEventStatusCode, Common.WorkloadEventStatus.InProcess);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void WorkloadEventStatusCode_Fail()
		{
		}

		[Test]
		public void WorkloadEventDate_Pass()
		{
			this._workloadEvent.WorkloadEventDate = System.DateTime.Today;
			Assert.AreEqual(this._workloadEvent.WorkloadEventDate, System.DateTime.Today);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void WorkloadEventDate_Fail()
		{
		}

		[Test]
		public void ProcessedDate_Pass()
		{
			this._workloadEvent.ProcessedDate = System.DateTime.Today;
			Assert.AreEqual(this._workloadEvent.ProcessedDate, System.DateTime.Today);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ProcessedDate_Fail()
		{
		}

		[Test]
		public void RecordSentIndicator_Pass()
		{
			this._workloadEvent.RecordSentIndicator = true;
			Assert.AreEqual(this._workloadEvent.RecordSentIndicator, true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordSentIndicator_Fail()
		{
		}

		[Test]
		public void PceEncounterNumber_Pass()
		{
			this._workloadEvent.PceEncounterNumber = "1234567-12345";
			Assert.AreEqual(this._workloadEvent.PceEncounterNumber, "1234567-12345");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BOL.BusinessObjectException))]
		public void PceEncounterNumber_Fail()
		{
			this._workloadEvent.PceEncounterNumber = "".PadRight(16,'X');
		}

		[Test]
		public void ErrorText_Pass()
		{
			this._workloadEvent.ErrorText = "ERROR TEXT";
			Assert.AreEqual(this._workloadEvent.ErrorText, "ERROR TEXT");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BOL.BusinessObjectException))]
		public void ErrorText_Fail()
		{
			this._workloadEvent.ErrorText = "".PadRight(256,'X');
		}

		[Test]
		public void VistaTechId_Pass()
		{
			this._workloadEvent.VistaTechId = "TECHID";
			Assert.AreEqual(this._workloadEvent.VistaTechId, "TECHID");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BOL.BusinessObjectException))]
		public void VistaTechId_Fail()
		{
			this._workloadEvent.VistaTechId = "".PadRight(20,'X');
		}

		#endregion
	}
}
#endif
